-- --------------------------------------------------------
-- Maian Ads / Schematic for MySQL5
-- --------------------------------------------------------

-- Structure for table ads_adverts
DROP TABLE IF EXISTS `ads_adverts`;
CREATE TABLE IF NOT EXISTS `ads_adverts` (
  `TableKey` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `KeyWord` text,
  `Title` varchar(45) NOT NULL DEFAULT '',
  `URL` varchar(150) NOT NULL DEFAULT '',
  `DISPLAYURL` varchar(145) NOT NULL DEFAULT '',
  `isdoubleunderline` tinyint(1) NOT NULL DEFAULT '1',
  `addType` varchar(50) NOT NULL DEFAULT '',
  `n_displays` varchar(5) NOT NULL DEFAULT '0',
  `n_clicks` varchar(5) NOT NULL DEFAULT '0',
  `enabled` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`TableKey`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- Data for table ads_adverts: 
INSERT INTO `ads_adverts` (`TableKey`, `KeyWord`, `Title`, `URL`, `DISPLAYURL`, `isdoubleunderline`, `addType`, `n_displays`, `n_clicks`, `enabled`) VALUES
	(1, 'commission bump,front end,memersnap', 'Amazing Product, $4+ Epcs, Low Refunds - Prom', 'http://cvault.membersnap.hop.clickbank.net/', 'Promote Membersnap', 1, 'CB', '0', '0', '1'),
	(2, 'yacht,boat,niche', 'Sell The Latest Cad Boat Software & Make Easy', 'http://cvault.boatdesign.hop.clickbank.net/', 'Cad Boat Software', 0, 'CB', '0', '0', '1'),
	(3, 'seo,daddy,elite', 'Seo Elite: New Seo Software!', 'http://cvault.bryxen1.hop.clickbank.net/', 'Seo Elite', 1, 'CB', '0', '0', '1'),
	(4, 'directory,submission', 'Directory Submitter 4.0', 'https://paydotcom.com/a.page.php?id=117025&u=thaininja', 'Submitter', 1, 'PDC', '0', '0', '1'),
	(5, 'income,cash,ultimate', 'The  Ultimate Income System', 'https://paydotcom.com/a.page.php?id=113788&u=henslo', 'Income System', 0, 'PDC', '0', '0', '1'),
	(6, 'premium,seo blog power,blog', 'SEO Blog Power', 'https://paydotcom.com/a.page.php?id=116422&u=listechinc', 'SEO', 1, 'PDC', '0', '0', '1');

-- Structure for table ads_clickbankmarketplace
DROP TABLE IF EXISTS `ads_clickbankmarketplace`;
CREATE TABLE IF NOT EXISTS `ads_clickbankmarketplace` (
  `adID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `Id` varchar(100) NOT NULL,
  `PopularityRank` varchar(100) NOT NULL DEFAULT '',
  `Title` varchar(255) NOT NULL DEFAULT '',
  `Description` text,
  `Gravity` varchar(8) NOT NULL DEFAULT '',
  `EarnedPerSale` varchar(8) NOT NULL DEFAULT '',
  `PercentPerSale` varchar(8) NOT NULL DEFAULT '',
  `TotalEarningsPerSale` varchar(8) NOT NULL DEFAULT '',
  `TotalRebillAmt` varchar(100) NOT NULL DEFAULT '',
  `Referred` varchar(100) NOT NULL DEFAULT '',
  `Commission` varchar(100) NOT NULL DEFAULT '',
  `updateDate` date NOT NULL DEFAULT '0000-00-00',
  `isRecurring` enum('0','1') NOT NULL DEFAULT '0',
  `category` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`adID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- Structure for table ads_pdcmarketplace
DROP TABLE IF EXISTS `ads_pdcmarketplace`;
CREATE TABLE IF NOT EXISTS `ads_pdcmarketplace` (
  `adID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `price` varchar(250) NOT NULL DEFAULT '',
  `date_added` date NOT NULL DEFAULT '0000-00-00',
  `seller_username` varchar(50) NOT NULL DEFAULT '',
  `description` text,
  `salespage` varchar(250) NOT NULL DEFAULT '',
  `promote_page` varchar(250) NOT NULL DEFAULT '',
  `main_category1` varchar(100) NOT NULL DEFAULT '',
  `category1` varchar(100) NOT NULL DEFAULT '',
  `main_category2` varchar(100) NOT NULL DEFAULT '',
  `category2` varchar(100) NOT NULL DEFAULT '',
  `affiliate_commission` varchar(100) NOT NULL DEFAULT '',
  `updateDate` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`adID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- Structure for table ads_program
DROP TABLE IF EXISTS `ads_program`;
CREATE TABLE IF NOT EXISTS `ads_program` (
  `id` int(3) unsigned NOT NULL AUTO_INCREMENT,
  `as_Version` varchar(5) NOT NULL DEFAULT '',
  `hideHomeMsg` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- Data for table dev_ads.ads_program: 1 rows
INSERT INTO `ads_program` (`id`, `version`, `hideHomeMsg`) VALUES (1, '1.1', '0');

-- Structure for table ads_stats
DROP TABLE IF EXISTS `ads_stats`;
CREATE TABLE IF NOT EXISTS `ads_stats` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `KeyWord` varchar(50) NOT NULL DEFAULT '',
  `addType` varchar(50) NOT NULL DEFAULT '',
  `addDate` date NOT NULL DEFAULT '0000-00-00',
  `adID` int(7) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `key_index` (`KeyWord`),
  KEY `adid_index` (`adID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- Structure for table ads_stats_clicks
DROP TABLE IF EXISTS `ads_stats_clicks`;
CREATE TABLE IF NOT EXISTS `ads_stats_clicks` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `clickCount` int(10) unsigned NOT NULL DEFAULT '0',
  `clickDate` date NOT NULL DEFAULT '0000-00-00',
  `addType` varchar(50) NOT NULL DEFAULT '',
  `asStat` int(7) NOT NULL DEFAULT '0',
  `adID` int(7) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `adid_index` (`adID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- Structure for table ads_stats_data
DROP TABLE IF EXISTS `ads_stats_data`;
CREATE TABLE IF NOT EXISTS `ads_stats_data` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ip` varchar(30) NOT NULL DEFAULT '',
  `refCount` int(10) unsigned NOT NULL DEFAULT '0',
  `referrer` varchar(255) NOT NULL DEFAULT '',
  `agent` varchar(255) NOT NULL DEFAULT '',
  `showDate` date NOT NULL DEFAULT '0000-00-00',
  `addType` varchar(50) NOT NULL DEFAULT '',
  `asStat` int(7) NOT NULL DEFAULT '0',
  `adID` int(7) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `adid_index` (`adID`),
  KEY `type_index` (`addType`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- Structure for table ads_stats_displays
DROP TABLE IF EXISTS `ads_stats_displays`;
CREATE TABLE IF NOT EXISTS `ads_stats_displays` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `displayCount` int(10) unsigned NOT NULL DEFAULT '0',
  `displayDate` date NOT NULL DEFAULT '0000-00-00',
  `addType` varchar(50) NOT NULL DEFAULT '',
  `asStat` int(7) NOT NULL DEFAULT '0',
  `adID` int(7) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `adid_index` (`adID`),
  KEY `adstat_index` (`asStat`),
  KEY `type_index` (`addType`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
